
SET @msgtemplateconfigId=(SELECT id FROM msg_template_config where code ='Student Login Credential');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId,'4','Student Login Credentials','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your admission has been approved with following details :&nbsp;</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Program :&nbsp;<strong>$templateData[&quot;PROGRAM_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Batch :&nbsp;<strong>$templateData[&quot;BATCH_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Seat type&nbsp;:&nbsp;<strong>$templateData[&quot;SEAT_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Academy :&nbsp;<strong>$templateData[&quot;ACADEMY_NAME&quot;]&nbsp;$templateData[&quot;LOCATION_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">You can Login to Academia&nbsp;with following credential</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>
');


SET @msgtemplateconfigId2=(SELECT id FROM msg_template_config where code ='Applicant Login Credential');
INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId2,'4','Applicant Login Credential','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] &nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</strong> Your login&nbsp;credentials are as follows<br />
			<br />
			LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password :&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>
');


SET @student=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    admission T1
        INNER JOIN
    students T2 ON T2.userId = T1.studentId
        INNER JOIN
    `persons` T3 ON T3.id = T2.personId
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams) group by T1.id" WHERE `dataProviderId`=@student;
    
    
SET @applicant=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_LOGIN_CREDENTIAL_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id as ID,
	T4.`firstName` AS FIRST_NAME,
	T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
	T4.`mobileNumber` AS MOBILE_NO,
	T4.`mobileCountryCode` AS MOBILE_CODE,
    (select
        distinct FORMAT(sum(feestagehe7_.feeAmount), 0) as y1_
    from
        fee_plan this_ 
    left outer join
        currency currency2_ 
            on this_.currencyId=currency2_.id 
    left outer join
        fee_plan_acad_locations feeplanaca1_ 
            on this_.id=feeplanaca1_.feePlanId 
    left outer join
        prog_batch_seat_config programbat3_ 
            on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
    left outer join
        fee_plan_rules feeplanrul4_ 
            on this_.id=feeplanrul4_.feePlanId 
    left outer join
        fee_plan_rule_stage feeplanrul5_ 
            on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
    left outer join
        fee_stage_master feeplansta6_ 
            on feeplanrul5_.stageId=feeplansta6_.id 
    left outer join
        fee_stage_head_config feestagehe7_ 
            on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
    where
        this_.feePlanStatus='ACTIVE' 
        and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE' 
        and programbat3_.id = T5.progBatchSeatConfigId 
        and feeplansta6_.stageName='Application form sale' 
    group by
        feeplanrul5_.id
) as 'FEE',
'APPLICANT' AS USER_TYPE_KEY,
ml.code as LANGUAGE_KEY,
T3.code AS APPLICATION_CODE
 from external_users T1
	left join external_user_association T2 on T2.externalUserId=T1.id
    left join application T3 on T3.id=T2.applicationId
    left join applicant_person T4 on T4.id=T3.applicantPersonId
    left join application_program T5 on T5.applicationId=T3.id 
    LEFT JOIN multi_language ml on T4.correspondence_language=ml.id
    where T1.id in (namedParams)" WHERE `dataProviderId`=@applicant;
    
    
SET @applicantAdhoc=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_ADHOC');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    'APPLICANT' AS USER_TYPE_KEY
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@applicantAdhoc; 
